# 機能設計書 147-CRI API定義

## 概要

本ドキュメントは、Kubernetes Container Runtime Interface（CRI）のgRPC APIプロトコル定義について記述する。CRI APIはKubeletとコンテナランタイム（containerd、CRI-O等）間の通信プロトコルを定義する。

### 本機能の処理概要

**業務上の目的・背景**：Kubernetesは特定のコンテナランタイムに依存しない設計を目指している。CRI APIはKubeletとコンテナランタイムの間の標準インターフェースを定義し、異なるコンテナランタイムを透過的に利用可能にする。これによりcontainerd、CRI-O等のランタイムを自由に選択できる。

**機能の利用シーン**：KubeletがPodやコンテナのライフサイクル管理を行う際に使用される。Pod Sandboxの作成/停止/削除、コンテナの作成/起動/停止/削除、exec/attach/port-forward、イメージ管理、統計情報取得などのすべてのコンテナ操作でCRI APIが使用される。

**主要な処理内容**：
1. RuntimeService: Pod Sandboxおよびコンテナのライフサイクル管理RPC定義
2. ImageService: コンテナイメージの管理RPC定義
3. Pod Sandbox管理: RunPodSandbox, StopPodSandbox, RemovePodSandbox, PodSandboxStatus, ListPodSandbox
4. コンテナ管理: CreateContainer, StartContainer, StopContainer, RemoveContainer, ListContainers, ContainerStatus
5. 実行/アタッチ: ExecSync, Exec, Attach, PortForward
6. 統計情報: ContainerStats, ListContainerStats, PodSandboxStats
7. イメージ管理: ListImages, ImageStatus, PullImage, RemoveImage, ImageFsInfo

**関連システム・外部連携**：Kubelet、containerd、CRI-O、その他CRI準拠ランタイム

**権限による制御**：CRI APIはUnixソケット経由のローカル通信であり、ソケットファイルのパーミッションで制御される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | kubectl exec | 間接利用 | CRI Exec APIを経由してコンテナ内コマンド実行 |
| - | kubectl logs | 間接利用 | CRI ContainerStatus APIでログパスを取得 |

## 機能種別

gRPCプロトコル定義 / インターフェース仕様

## 入力仕様

### 入力パラメータ（主要RPC）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| RunPodSandboxRequest.config | PodSandboxConfig | Yes | Pod Sandboxの設定 | 有効な設定値 |
| CreateContainerRequest.pod_sandbox_id | string | Yes | Pod Sandbox ID | 既存のSandbox ID |
| CreateContainerRequest.config | ContainerConfig | Yes | コンテナの設定 | 有効な設定値 |
| ExecSyncRequest.container_id | string | Yes | コンテナID | 既存のコンテナID |
| ExecSyncRequest.cmd | []string | Yes | 実行コマンド | 非空の文字列配列 |
| PullImageRequest.image | ImageSpec | Yes | プルするイメージの仕様 | 有効なイメージ参照 |

### 入力データソース

KubeletからのgRPCリクエスト（Unixソケット経由）。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| RunPodSandboxResponse.pod_sandbox_id | string | 作成されたSandboxのID |
| CreateContainerResponse.container_id | string | 作成されたコンテナのID |
| ContainerStatusResponse.status | ContainerStatus | コンテナの状態情報 |
| ExecSyncResponse.stdout/stderr | bytes | コマンド実行結果 |
| PullImageResponse.image_ref | string | プルされたイメージの参照 |

### 出力先

Kubelet（gRPCレスポンス）。

## 処理フロー

### 処理シーケンス

```
1. Kubeletがコンテナ操作の必要性を検知
   └─ Pod Specの変更、Probeの実行等
2. CRI gRPCクライアントがリクエストを構築
   └─ Protobufメッセージのシリアライズ
3. Unixソケット経由でランタイムにRPC送信
   └─ gRPC通信
4. コンテナランタイムがRPC処理を実行
   └─ containerd/CRI-O等の実装
5. レスポンスをKubeletに返却
   └─ gRPCレスポンス
```

### フローチャート

```mermaid
flowchart TD
    A[Kubelet] --> B{操作種別}
    B -->|Pod Sandbox| C[RunPodSandbox / StopPodSandbox / RemovePodSandbox]
    B -->|Container| D[CreateContainer / StartContainer / StopContainer]
    B -->|Exec/Attach| E[ExecSync / Exec / Attach / PortForward]
    B -->|Image| F[PullImage / RemoveImage / ListImages]
    B -->|Stats| G[ContainerStats / PodSandboxStats]
    C --> H[gRPC Request via Unix Socket]
    D --> H
    E --> H
    F --> H
    G --> H
    H --> I[Container Runtime]
    I --> J[gRPC Response]
    J --> A
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-147-01 | べき等性 | StopPodSandbox, RemovePodSandbox, StopContainer, RemoveContainerはべき等 | 常時 |
| BR-147-02 | Sandboxライフサイクル | コンテナはSandbox内に作成され、Sandbox削除時にコンテナも強制削除される | 常時 |
| BR-147-03 | グレースフル停止 | StopContainerにはgrace period（タイムアウト）が指定される | コンテナ停止時 |
| BR-147-04 | ストリーミング | Exec/Attach/PortForwardはストリーミングエンドポイントURLを返す | ストリーミング操作時 |

### 計算ロジック

該当なし（プロトコル定義）。

## データベース操作仕様

CRI API自体はデータベース操作を行わない。コンテナランタイムがローカルストレージにコンテナメタデータを保存する。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| NotFound | gRPC NotFound | 指定されたSandbox/コンテナが存在しない | IDを確認 |
| Unavailable | gRPC Unavailable | ランタイムに接続できない | ランタイムの状態を確認 |
| DeadlineExceeded | gRPC Timeout | RPC処理がタイムアウト | タイムアウト値を調整 |

### リトライ仕様

Kubelet側（CRIクライアント）でリトライポリシーが実装される。

## トランザクション仕様

該当なし（各RPC呼び出しは独立した操作）。

## パフォーマンス要件

コンテナのライフサイクル操作に直接影響するため、低レイテンシが求められる。Unixソケット通信によりネットワークオーバーヘッドを最小化。

## セキュリティ考慮事項

- CRIソケットへのアクセスはroot権限が必要
- コンテナの設定（SecurityContext）はCRIを通じてランタイムに伝達される
- Exec/Attachはコンテナ内への直接アクセスを提供するため、適切な認可制御が必要

## 備考

- CRI APIはprotobuf v3で定義され、`hack/update-codegen.sh protobindings`で生成される
- 現在のAPIバージョンはv1（CRIVersionV1）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | api.proto | `staging/src/k8s.io/cri-api/pkg/apis/runtime/v1/api.proto` | CRI APIのprotobuf定義全体 |

**読解のコツ**: proto3構文で記述されている。service定義がRPCエンドポイント、message定義がリクエスト/レスポンス型を表す。RuntimeServiceとImageServiceの2つのサービスが定義されている。

**主要処理フロー**:
- **24-26行目**: RuntimeServiceのサービス定義開始
- **28-30行目**: Version RPC -- ランタイムバージョン取得
- **32-50行目**: Pod Sandbox管理RPC群 -- Run, Stop, Remove, Status, List
- **52-80行目**: コンテナ管理RPC群 -- Create, Start, Stop, Remove, List, Status, Update
- **82-89行目**: Exec/Attach/PortForward RPC群
- **91-100行目**: Stats RPC群 -- ContainerStats, PodSandboxStats

#### Step 2: 生成コードを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | api.pb.go | `staging/src/k8s.io/cri-api/pkg/apis/runtime/v1/api.pb.go` | protobufから生成されたGoコード |

#### Step 3: APIインターフェースを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | services.go | `staging/src/k8s.io/cri-api/pkg/apis/services.go` | Go言語でのCRIインターフェース定義 |

### プログラム呼び出し階層図

```
Kubelet
    |
    +-- CRI RuntimeService (gRPC)
    |       +-- Version()
    |       +-- RunPodSandbox() / StopPodSandbox() / RemovePodSandbox()
    |       +-- PodSandboxStatus() / ListPodSandbox()
    |       +-- CreateContainer() / StartContainer() / StopContainer() / RemoveContainer()
    |       +-- ListContainers() / ContainerStatus() / UpdateContainerResources()
    |       +-- ExecSync() / Exec() / Attach() / PortForward()
    |       +-- ContainerStats() / ListContainerStats()
    |       +-- PodSandboxStats() / ListPodSandboxStats()
    |       +-- ReopenContainerLog()
    |       +-- RuntimeStatus() / CheckpointContainer()
    |
    +-- CRI ImageService (gRPC)
            +-- ListImages() / ImageStatus()
            +-- PullImage() / RemoveImage()
            +-- ImageFsInfo()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Kubelet ──────> gRPC Request ──> Container Runtime ──> gRPC Response
(Pod Spec)     (Unix Socket)     (containerd/CRI-O)    (Status/ID)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| api.proto | `staging/src/k8s.io/cri-api/pkg/apis/runtime/v1/api.proto` | プロトコル定義 | CRI gRPC API定義 |
| api.pb.go | `staging/src/k8s.io/cri-api/pkg/apis/runtime/v1/api.pb.go` | 生成コード | protobufから生成されたGoコード |
| services.go | `staging/src/k8s.io/cri-api/pkg/apis/services.go` | ソース | GoインターフェースとしてのCRI定義 |
| errors/ | `staging/src/k8s.io/cri-api/pkg/errors/` | ソース | CRIエラー定義 |
